package gov.va.med.mhv.usermgmt.service.adapter;

import gov.va.med.mhv.core.util.PropertiesUtil;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

public class MpiProperties {
	
	// TODO Refactor to use AbstractBaseProperties
    
    private static final Log LOG = LogFactory.getLog(MpiProperties.class);
    
    private static final String RESOURCE_NAME = "/mpi.properties";

    private static final String HOST = "host";
	private static final String PORT = "port";
	private static final String TIMEOUT = "timeout";
	private static final String SENDING_FACILITY = "sending.facility";
	private static final String RECEIVING_FACILITY = "receiving.facility";

    private static final String LINK_ENABLED = "link.enabled";
    private static final String UNLINK_ENABLED = "unlink.enabled";
    private static final String USE_MIDDLENAME_GENDER = "useMiddleNameAndGender";    
    
    private static final boolean reload = PropertiesUtil.getReloadProperties();

    private static MpiProperties INSTANCE = new MpiProperties();
    
    private final String host;
    private final int port;
    private final int timeout;
    private final String sendingFacility;
    private final String receivingFacility;
    private final boolean linkEnabled;
    private final boolean unlinkEnabled;
    private final boolean useMiddleNameAndGender;
    
    public static MpiProperties getInstance() {
        return (reload) ? new MpiProperties() : INSTANCE;
    }

	private MpiProperties() {
        Properties properties = ConfigurationManager.getConfiguration(
            RESOURCE_NAME);
        host = PropertiesUtil.getValue(RESOURCE_NAME, properties, HOST, null);
        port = PropertiesUtil.getIntValue(RESOURCE_NAME, properties, PORT, 0);
        timeout = PropertiesUtil.getIntValue(RESOURCE_NAME, properties, 
            TIMEOUT, 0);
        sendingFacility = PropertiesUtil.getValue(RESOURCE_NAME, properties, 
            SENDING_FACILITY, null);
        receivingFacility = PropertiesUtil.getValue(RESOURCE_NAME, properties, 
            RECEIVING_FACILITY, null);
        linkEnabled = (properties != null) ? Boolean.parseBoolean(
            properties.getProperty(LINK_ENABLED)) : false;
        unlinkEnabled = (properties != null) ? Boolean.parseBoolean(
            properties.getProperty(UNLINK_ENABLED)) : false;
            useMiddleNameAndGender = (properties != null) ? Boolean.parseBoolean(
                    properties.getProperty(USE_MIDDLENAME_GENDER)) : false;            
        if (LOG.isInfoEnabled()) {
            LOG.info("Using " + describe());
        }
	}
	
	public String getHost() {
		return host;
	}
	
	public int getPort() {
		return port;
	}
	
	public int getTimeout() {
		return timeout;
	}
	
	public String getSendingFacility() {
		return sendingFacility;
	}
	
	public String getReceivingFacility() {
		return receivingFacility;
	}

    public boolean isLinkEnabled() {
        return linkEnabled;
    }

    public boolean isUnlinkEnabled() {
        return unlinkEnabled;
    }

	public boolean isUseMiddleNameAndGender() {
		return useMiddleNameAndGender;
	}
	
    public String describe() {
        StringBuilder builder = new StringBuilder();
        builder.append("MpiProperties[");
        builder.append("host=").append(host);
        builder.append("; port=").append(port);
        builder.append("; timeout=").append(timeout);
        builder.append("; sendingFacility=").append(sendingFacility);
        builder.append("; receivingFacility=").append(receivingFacility);
        builder.append("; link=").append(((linkEnabled) ? "enabled" 
            : "disabled"));
        builder.append("; unlink=").append(((unlinkEnabled) ? "enabled" 
            : "disabled"));
        builder.append("; useMiddleNameAndGender=").append(((useMiddleNameAndGender) ? "enabled" 
                : "disabled"));        
        builder.append("]");
        return builder.toString();
    }
}
